--[[----------------------------------------------------------------------------

ICATetherServiceProvider.lua
Tether service provider description for Lightroom sample Tether plugin

--------------------------------------------------------------------------------

ADOBE SYSTEMS INCORPORATED
 Copyright 2019 Adobe Incorporated
 All Rights Reserved.

NOTICE: Adobe permits you to use, modify, and distribute this file in accordance
with the terms of the Adobe license agreement accompanying it. If you have received
this file from a source other than Adobe, then your use, modification, or distribution
of it requires the prior written permission of Adobe.

------------------------------------------------------------------------------]]

	-- Lightroom SDK

	-- Sample plug-in
local TetherTask = require 'TetherTask'

--============================================================================--

return {

	init = TetherTask.init,
	shutdown = TetherTask.shutdown,
	
	setCallback = TetherTask.setCallback,
		
	queryDevices = TetherTask.queryDevices,
	connectDevice = TetherTask.connectDevice,
	disconnectDevice = TetherTask.disconnectDevice,
	
	getCameraSettings = TetherTask.getCameraSettings,
	setCameraSettings = TetherTask.setCameraSettings,	
	
	doCapture = TetherTask.doCapture,
	
	pollForMessages = TetherTask.pollForMessages,
	
	startDownload = TetherTask.startDownload,	
}


