/* SPDX-License-Identifier: GPL-2.0+ */
/*
 * Copyright (C) 2019 Socionext Inc.
 */

#ifndef __SC2006A_EVB_H__
#define __SC2006A_EVB_H__

/* Enable distro boot support */
#ifdef CONFIG_CMD_MMC
#define BOOT_TARGET_DEVICE_MMC(func)   func(MMC, mmc, 0) func(MMC, mmc, 1)
#else
#define BOOT_TARGET_DEVICE_MMC(func)
#endif

#define BOOT_TARGET_DEVICES(func)	\
	BOOT_TARGET_DEVICE_MMC(func)

#include <config_distro_bootcmd.h>

#define CONFIG_BOOTFILE		"Image"
#define	LINUXBOOT_CMD		"booti"
#define KERNEL_ADDR_R		"kernel_addr_r=0x480000000\0"
#define FDT_ADDR_R		"fdt_addr_r=0x482000000\0"
#define RAMDISK_ADDR_R		"ramdisk_addr_r=0x482010000\0"
#define SCRIPTADDR		"0x481ff0000"
#define PXEFILE_ADDR_R		"pxefile_addr_r=" SCRIPTADDR "\0"	\
				"scriptaddr=" SCRIPTADDR "\0"

#define LEGACY_BOOT_CMD			\
	"legacyboot=fatload mmc 0 $kernel_addr_r KERNEL.BIN &&"	\
		"fatload mmc 0 $fdt_addr_r DTB.BI &&"		\
		"fatload mmc 0 $ramdisk_addr_r RAMFS.BIN &&"	\
		"booti $kernel_addr_r - $fdt_addr_r\0"

#define CONFIG_EXTRA_ENV_SETTINGS	\
	KERNEL_ADDR_R			\
	FDT_ADDR_R			\
	RAMDISK_ADDR_R			\
	PXEFILE_ADDR_R			\
	LEGACY_BOOT_CMD			\
	BOOTENV

#define CONFIG_LOADADDR			0x440000000
#define CONFIG_SYS_LOAD_ADDR		CONFIG_LOADADDR

#define CONFIG_SYS_INIT_SP_ADDR		(CONFIG_SYS_TEXT_BASE)

#define	GICD_BASE	0x0d000000
#define	GICR_BASE	0x0d080000

#if CONFIG_COUNTER_FREQUENCY
#define COUNTER_FREQUENCY	CONFIG_COUNTER_FREQUENCY
#endif

#endif
