/*
 * exmem.h - exmem driver include file
 *
 * Copyright (c) 2020 Panasonic Corporation
 * 2020-09-28 Modified
 *
 * This file may be used subject to the terms and conditions of the
 * GNU General Public License Version 2, or any later version
 * at your option, as published by the Free Software Foundation.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 */
#include <asm/ioctl.h>

#ifndef __PVC_EXMEM_H__
#define __PVC_EXMEM_H__

#define EXMEM_CACHE_FLUSH_ALL		_IO('p', 0x01)		/*  */
#define EXMEM_CACHE_FLUSH_ICACHE_ALL	_IO('p', 0x02)		/*  */
#define EXMEM_CACHE_FLUSH_DCACHE_RANGE	_IO('p', 0x03)		/*  */

typedef struct exmem_cache_t {
	void* addr;						/* virtual address */
	size_t size; 						/* size */
}EXMEM_CACHE;


#define DEVICE_NAME			"exmem"			/*  */

#define EXMEM_MINOR_NUM			1			/*  */

#define EXMEM_VERSION			"1.0"			/*  */

#endif /* __PVC_EXMEM_H__ */
