/*
 * Copyright (c) 2013-     Panasonic Corporation
 * $Id$
 */
/**
   @file    Usbhd_Event.h
   @author  
   @brief   USB Host Controller Driver / Event
*/

#ifndef _USBHD_EVENT_H_
#define	_USBHD_EVENT_H_


/*---------------------------------------------------------------------------*/
#define USBHD_PAYLOAD_SIZE			128
/*---------------------------------------------------------------------------*/
/**
 * command
 */
#define USBHD_CMD_INVALID			0x00
#define USBHD_CMD_START				0x01		/* Request, Response */
#define USBHD_CMD_STOP				0x02		/* Request, Response */
#define USBHD_CMD_CTRL				0x03		/* Request, Response */
#define USBHD_CMD_BULK				0x04		/* Request, Response */
#define USBHD_CMD_CLEARHALT			0x08		/* Request, Response */
#define USBHD_CMD_ENTER_TEST_MODE	0x10		/* Request, Response */
#define USBHD_CMD_EXIT_TEST_MODE	0x11		/* Request, Response */
#define USBHD_CMD_DETACH			0x80		/* Notify */
#define USBHD_CMD_ATTACH			0x81		/* Notify */
#define USBHD_CMD_EMERGENCY			0x8F		/* Notify */
#define USBHD_CMD_STOP_CMP			0x90		/* Notify */

/**
 * subcommand
 */
/** test mode */
#define USBHD_TEST_J				1			/* @see: USB_TEST_J */
#define USBHD_TEST_K				2			/* @see: USB_TEST_K */
#define USBHD_TEST_SE0_NAK			3			/* @see: USB_TEST_SE0_NAK */
#define USBHD_TEST_PACKET			4			/* @see: USB_TEST_PACKET */
#define USBHD_TEST_FORCE_ENABLE		5			/* @see: USB_TEST_FORCE_ENABLE */

/** transfer direction */
#define USBHD_DIR_HOST2DEV			0			/* @see: USB_HOST2DEV */
#define USBHD_DIR_DEV2HOST			1			/* @see: USB_DEV2HOST */

/**
 * status
 */
#define USBHD_STS_COMPLETION		0			/* @see: USBHD_ERR_COMPLETION */
#define USBHD_STS_STALLED			1			/* @see: USBHD_ERR_STALLED */
#define USBHD_STS_CANCELLED			2			/* @see: USBHD_ERR_CANCELLED */
#define USBHD_STS_TIMEOUT			3			/* @see: USBHD_ERR_TIMEOUT */
#define USBHD_STS_INVAL				4			/* @see: USBHD_ERR_INVAL */
#define USBHD_STS_OTHER				98			/* @see: USBHD_ERR_OTHER */
#define USBHD_STS_NOOPERATION		99			/* @see: USBHD_ERR_NOOPERATION */

/**
 * speed
 */
#define USBHD_SPEED_UNKNOWN			0			/* @see: USB_SPEED_UNKNOWN */
#define USBHD_SPEED_LOW				1			/* @see: USB_SPEED_LOW */
#define USBHD_SPEED_FULL			2			/* @see: USB_SPEED_FULL */
#define USBHD_SPEED_HIGH			3			/* @see: USB_SPEED_HIGH */
#define USBHD_SPEED_VARIABLE		4			/* @see: USB_SPEED_VARIABLE */
#define USBHD_SPEED_SUPER			5			/* @see: USB_SPEED_SUPER */
#define USBHD_SPEED_SUPER_PLUS		6			/* @see: USB_SPEED_SUPER_PLUS */


/*---------------------------------------------------------------------------*/
#pragma pack(1) /* Alignment: 1byte */

/**
 * common
 */
typedef struct {
	unsigned char	length;
	unsigned char	command;
	unsigned char	status;						/* Response, Notify */
} USBHD_COMMON_HEADER;

/**
 * Request
 */
/** Header  */
typedef struct {
	unsigned char	length;
	unsigned char	command;
	unsigned char	subcommand;
	unsigned char	speed;
	unsigned char	address;
	unsigned char	endpoint_number;
	unsigned short	submit_timeout;				/* little endian */
	unsigned long	buff_addr;					/* little endian */
	unsigned long	buff_size;					/* little endian */
} USBHD_REQUEST_HEADER;

/** Start */
typedef struct {
	USBHD_REQUEST_HEADER	header;
} USBHD_REQUEST_START;

/** Stop */
typedef struct {
	USBHD_REQUEST_HEADER	header;
} USBHD_REQUEST_STOP;

/** Test */
typedef struct {
	USBHD_REQUEST_HEADER	header;
} USBHD_REQUEST_TEST;

/** Clear Halt */
typedef struct {
	USBHD_REQUEST_HEADER	header;
} USBHD_REQUEST_CLEARHALT;

/** Ctrl */
typedef struct {
	USBHD_REQUEST_HEADER	header;
	unsigned char payload[USBHD_PAYLOAD_SIZE - sizeof(USBHD_REQUEST_HEADER)];
} USBHD_REQUEST_CTRL;

/** Bulk */
typedef struct {
	USBHD_REQUEST_HEADER	header;
	unsigned char payload[USBHD_PAYLOAD_SIZE - sizeof(USBHD_REQUEST_HEADER)];
} USBHD_REQUEST_BULK;



/**
 * Response
 */
typedef struct {
	unsigned char	length;
	unsigned char	command;
	unsigned char	status;
	unsigned char	speed;
	unsigned char	address;
	unsigned char	endpoint_number;
	unsigned short	submit_timeout;				/* little endian */
	unsigned long	buff_addr;					/* little endian */
	unsigned long	buff_size;					/* little endian */
} USBHD_RESPONSE_HEADER;

/** Start */
typedef struct {
	USBHD_RESPONSE_HEADER	header;
} USBHD_RESPONSE_START;

/** Stop */
typedef struct {
	USBHD_RESPONSE_HEADER	header;
} USBHD_RESPONSE_STOP;

/** Test */
typedef struct {
	USBHD_RESPONSE_HEADER	header;
} USBHD_RESPONSE_TEST;

/** Clear Halt */
typedef struct {
	USBHD_RESPONSE_HEADER	header;
} USBHD_RESPONSE_CLEARHALT;

/** Ctrl */
typedef struct {
	USBHD_RESPONSE_HEADER	header;
	unsigned char payload[USBHD_PAYLOAD_SIZE - sizeof(USBHD_RESPONSE_HEADER)];
} USBHD_RESPONSE_CTRL;

/** Bulk */
typedef struct {
	USBHD_RESPONSE_HEADER	header;
	unsigned char payload[USBHD_PAYLOAD_SIZE - sizeof(USBHD_RESPONSE_HEADER)];
} USBHD_RESPONSE_BULK;


/**
 * Notify
 */
typedef struct {
	unsigned char	length;
	unsigned char	command;
	unsigned char	status;
	unsigned char	speed;
	unsigned char	address;
	unsigned char	endpoint_number;
	unsigned char	reserved1;
	unsigned char	reserved2;
	unsigned long	buff_addr;					/* little endian */
	unsigned long	buff_size;					/* little endian */
} USBHD_NOTIFY_HEADER;

/** Attach */
typedef struct {
	USBHD_NOTIFY_HEADER	header;
	unsigned char payload[USBHD_PAYLOAD_SIZE - sizeof(USBHD_NOTIFY_HEADER)];
} USBHD_NOTIFY_ATTACH;

/** Detach */
typedef struct {
	USBHD_NOTIFY_HEADER	header;
} USBHD_NOTIFY_DETACH;

/** Emergency */
typedef struct {
	USBHD_NOTIFY_HEADER	header;
} USBHD_NOTIFY_EMERGENCY;


/**
 * Event
 */
typedef union {
	unsigned char	buffer[USBHD_PAYLOAD_SIZE];
	
	union {
		USBHD_COMMON_HEADER			header;
	} common;
	
	union {
		USBHD_REQUEST_START			start;
		USBHD_REQUEST_STOP			stop;
		USBHD_REQUEST_TEST			test;
		USBHD_REQUEST_CLEARHALT		clearhalt;
		USBHD_REQUEST_CTRL			ctrl;
		USBHD_REQUEST_BULK			bulk;
	} request;
	
	union {
		USBHD_RESPONSE_START		start;
		USBHD_RESPONSE_STOP			stop;
		USBHD_RESPONSE_TEST			test;
		USBHD_RESPONSE_CLEARHALT	clearhalt;
		USBHD_RESPONSE_CTRL			ctrl;
		USBHD_RESPONSE_BULK			bulk;
	} response;
	
	union {
		USBHD_NOTIFY_ATTACH			attach;
		USBHD_NOTIFY_DETACH			detach;
		USBHD_NOTIFY_EMERGENCY		emergency;
	} notify;
	
} USBHD_EVENT;

#pragma pack() /* Alignment: revert */

#endif	/* _USBHD_EVENT_H_ */
