// SPDX-License-Identifier: GPL-2.0
/*
 * pvc04v-DC1232-rtos.h - rtos for DC1232
 *
 * Copyright (c) 2020 Panasonic Corporation
 * 2020-07-16 Modified
 *
 * This file may be used subject to the terms and conditions of the
 * GNU General Public License Version 2, or any later version
 * at your option, as published by the Free Software Foundation.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 */
 
/* common shared memory */
#define SHMEM_TOP_ADDRU		0x00000004
#define SHMEM_TOP_ADDRL		0xAC000000
#define SHMEM_TOP_ADDR_SIZE	0x00000200

#define SHMEM_IPCU_BUFFER_ADDR_OFFSET	0x08
#define SHMEM_IPCU_BUFFER_SIZE_OFFSET	0x10
#define SHMEM_IPCU_SYNC_ADDR_OFFSET	0x18
#define SHMEM_IPCU_SYNC_SIZE_OFFSET	0x20
#define SHMEM_MOVIE_ADDR_OFFSET	0x28
#define SHMEM_MOVIE_SIZE_OFFSET	0x30
#define SHMEM_AUDIO_ADDR_OFFSET	0x38
#define SHMEM_AUDIO_SIZE_OFFSET	0x40

/* macro */
#define GET_IPCU_BUFFER_ADDRU	SHMEM_TOP_ADDRU
#define GET_IPCU_BUFFER_ADDRL	(SHMEM_TOP_ADDRL + SHMEM_IPCU_BUFFER_ADDR_OFFSET)
#define GET_IPCU_BUFFER_SIZEU	SHMEM_TOP_ADDRU
#define GET_IPCU_BUFFER_SIZEL	(SHMEM_TOP_ADDRL + SHMEM_IPCU_BUFFER_SIZE_OFFSET)
#define GET_IPCU_SYNC_ADDRU	SHMEM_TOP_ADDRU
#define GET_IPCU_SYNC_ADDRL	(SHMEM_TOP_ADDRL + SHMEM_IPCU_SYNC_ADDR_OFFSET)
#define GET_IPCU_SYNC_SIZEU	SHMEM_TOP_ADDRU
#define GET_IPCU_SYNC_SIZEL	(SHMEM_TOP_ADDRL + SHMEM_IPCU_SYNC_SIZE_OFFSET)
#define GET_MOVIE_ADDRU	SHMEM_TOP_ADDRU
#define GET_MOVIE_ADDRL	(SHMEM_TOP_ADDRL + SHMEM_MOVIE_ADDR_OFFSET)
#define GET_MOVIE_SIZEU	SHMEM_TOP_ADDRU
#define GET_MOVIE_SIZEL	(SHMEM_TOP_ADDRL + SHMEM_MOVIE_SIZE_OFFSET)
#define GET_AUDIO_ADDRU	SHMEM_TOP_ADDRU
#define GET_AUDIO_ADDRL	(SHMEM_TOP_ADDRL + SHMEM_AUDIO_ADDR_OFFSET)
#define GET_AUDIO_SIZEU	SHMEM_TOP_ADDRU
#define GET_AUDIO_SIZEL	(SHMEM_TOP_ADDRL + SHMEM_AUDIO_SIZE_OFFSET)
